/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.model;

import java.util.Collection;
import java.util.LinkedList;
import uni.hro.model.Creature;
import uni.hro.model.IntegerPoint;
import uni.hro.model.WorldEntity;

public class HitBox {
    private IntegerPoint offset;
    private Creature creature;
    private Collection<WorldEntity> perceivedEntities = new LinkedList<WorldEntity>();
    public static final float HALF_WIDTH = 12.0f;
    public static final float WIDTH = 24.0f;

    public HitBox(Creature creature, IntegerPoint offset) {
        this.creature = creature;
        this.offset = offset;
    }

    public HitBox() {
    }

    public void clear() {
        this.perceivedEntities.clear();
    }

    public HitBox addPerceivedEntity(WorldEntity entity) {
        this.perceivedEntities.add(entity);
        return this;
    }

    public int getLeftX() {
        float leftX = this.creature.getX() - 12.0f;
        float delta = (float)((Integer)this.offset.getX()).intValue() * 24.0f;
        if (this.creature.looksLeft()) {
            delta *= -1.0f;
        }
        return (int)(leftX + delta);
    }

    public int getRightX() {
        float leftX = this.creature.getX() + 12.0f;
        float delta = (float)((Integer)this.offset.getX()).intValue() * 24.0f;
        if (this.creature.looksLeft()) {
            delta *= -1.0f;
        }
        return (int)(leftX + delta);
    }

    public int getTopY() {
        float y = this.creature.getY() - 12.0f;
        float delta = (float)((Integer)this.offset.getY()).intValue() * 24.0f;
        return (int)(y + delta);
    }

    public int getBottomY() {
        float y = this.creature.getY() + 12.0f;
        float delta = (float)((Integer)this.offset.getY()).intValue() * 24.0f;
        return (int)(y + delta);
    }

    public Collection<WorldEntity> getPerceivedEntities() {
        return this.perceivedEntities;
    }
}

