/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.model;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import uni.hro.model.Creature;
import uni.hro.model.Fish;
import uni.hro.model.Food;
import uni.hro.model.Kraken;
import uni.hro.model.Plant;
import uni.hro.model.Stone;
import uni.hro.model.WorldEntity;

public class World {
    private static Random rn = new Random();
    private final int width;
    private final int height;
    private Set<WorldEntity> entities = new HashSet<WorldEntity>();

    public World(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public static World createRandomWorld1(int numberOfFishes, int numberOfKraken, int numberOfPlants, int numberOfStones, int displayWidth, int displayHeight) {
        World world = new World(displayWidth, displayHeight);
        int iterator1 = 0;
        while (iterator1 < numberOfFishes) {
            int newYValue = World.generateRandom(displayHeight - 30, displayHeight - 10);
            world.getEntities().add(new Fish(world, World.generateRandom(20, displayWidth - 100), World.generateRandom(30, displayHeight - 30)));
            ++iterator1;
        }
        int iterator3 = 0;
        while (iterator3 < numberOfKraken) {
            int newYValue = World.generateRandom(displayHeight - 30, displayHeight - 10);
            world.getEntities().add(new Kraken(world, World.generateRandom(20, displayWidth - 100), World.generateRandom(30, displayHeight - 30)));
            ++iterator3;
        }
        int iterator = 0;
        int oldYValue = 0;
        while (iterator < numberOfStones) {
            int newYValue = World.generateRandom(displayHeight - 65, displayHeight - 55);
            if (oldYValue >= newYValue) continue;
            world.getEntities().add(new Stone(world, World.generateRandom(20, displayWidth - 150), newYValue, 100.0f, 50.0f));
            ++iterator;
        }
        int iterator2 = 0;
        int oldYValue2 = 0;
        while (iterator2 < numberOfPlants) {
            int newYValue = World.generateRandom(displayHeight - 40, displayHeight - 30);
            if (oldYValue2 >= newYValue) continue;
            world.getEntities().add(new Plant(world, World.generateRandom(20, displayWidth - 100), newYValue, 100.0f, 100.0f));
            ++iterator2;
        }
        return world;
    }

    public static int generateRandom(int min, int max) {
        int randomvalue = rn.nextInt(max - min + 1) + min;
        return randomvalue;
    }

    public static float generateRandmF(float min, float max) {
        float r = rn.nextFloat();
        return min + (max - min) * r;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public Set<WorldEntity> getEntities() {
        return this.entities;
    }

    public void checkEntityCollision(Creature a2, WorldEntity b2) {
        if (a2.getLeftX() < b2.getRightX() && a2.getRightX() > b2.getLeftX() && a2.getTopY() < b2.getBottomY() && a2.getBottomY() > b2.getTopY() && !a2.equals(b2)) {
            if (a2 instanceof Fish && b2 instanceof Fish) {
                this.bounceOff(a2, b2);
            } else if (a2 instanceof Fish && b2 instanceof Food) {
                this.entities.remove(b2);
                a2.addFuel(2.0f);
            } else if (a2 instanceof Kraken && b2 instanceof Fish) {
                this.entities.remove(b2);
                a2.addFuel(2.0f);
            } else if (a2 instanceof Kraken && b2 instanceof Food) {
                this.entities.remove(b2);
            }
        }
    }

    public void bounceOff(WorldEntity a2, WorldEntity b2) {
        if (a2.vx > 0.0f) {
            if (b2.vx > 0.0f) {
                a2.vx = 10.0f;
                b2.vx = -10.0f;
            } else {
                a2.vx = -10.0f;
                b2.vx = 10.0f;
            }
        } else if (b2.vx > 0.0f) {
            a2.vx = 10.0f;
            b2.vx = -10.0f;
        } else {
            a2.vx = -10.0f;
            b2.vx = 10.0f;
        }
        if (a2.vy > 0.0f) {
            if (b2.vy > 0.0f) {
                a2.vy = 10.0f;
                b2.vy = -10.0f;
            } else {
                a2.vy = -10.0f;
                b2.vy = 10.0f;
            }
        } else if (b2.vy > 0.0f) {
            a2.vy = 10.0f;
            b2.vy = -10.0f;
        } else {
            a2.vy = -10.0f;
            b2.vy = 10.0f;
        }
    }
}

