/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.model;

import de.mein.core.serialize.SerializableEntity;
import java.awt.Color;
import uni.hro.draw.ColorGenerator;

public abstract class WorldEntity
implements SerializableEntity {
    protected Color color;
    protected Color currentColor;
    protected float x;
    protected float y;
    protected float vx;
    protected float vy;
    protected float dx;
    protected float dy;
    protected float halfWidth;
    protected float halfHeight;
    public static final int HALF_BLOCK_SIZE = 5;

    public WorldEntity(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.halfHeight = height / 2.0f;
        this.halfWidth = width / 2.0f;
        this.dy = 0.0f;
        this.dx = 0.0f;
        this.vy = 0.0f;
        this.vx = 0.0f;
        this.currentColor = this.color = ColorGenerator.mixRandomColor(this);
    }

    protected WorldEntity() {
    }

    public float getLeftX() {
        return this.x - this.halfWidth;
    }

    public float getRightX() {
        return this.x + this.halfWidth;
    }

    public float getTopY() {
        return this.y - this.halfHeight;
    }

    public float getBottomY() {
        return this.y + this.halfHeight;
    }

    public float getDx() {
        return this.dx;
    }

    public float getDy() {
        return this.dy;
    }

    public float getVx() {
        return this.vx;
    }

    public float getVy() {
        return this.vy;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getHalfWidth() {
        return this.halfWidth;
    }

    public float getHalfHeight() {
        return this.halfHeight;
    }

    public Color getCurrentColor() {
        return this.currentColor;
    }

    public void setCurrentColor(Color currentColor) {
        this.currentColor = currentColor;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void checkWorldCollision(int w, int h) {
        if (this.getRightX() >= (float)w) {
            this.vx = -1.0f;
        }
        if (this.getLeftX() <= 0.0f) {
            this.vx = 1.0f;
        }
        if (this.getTopY() <= 0.0f) {
            this.vy = 1.0f;
        }
        if (this.getBottomY() >= (float)h) {
            this.vy = -1.0f;
        }
    }
}

