/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.networking.service;

import de.mein.auth.data.db.Service;
import de.mein.auth.data.db.ServiceType;
import de.mein.auth.service.BootLoader;
import de.mein.auth.service.MeinAuthService;
import de.mein.auth.tools.N;
import de.mein.core.serialize.exceptions.JsonDeserializationException;
import de.mein.core.serialize.exceptions.JsonSerializationException;
import de.mein.sql.SqlQueriesException;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.jdeferred.Promise;
import org.jdeferred.impl.DeferredObject;
import uni.hro.networking.service.AquaClientService;
import uni.hro.networking.service.AquaServerService;
import uni.hro.networking.service.AquaService;

public class AquaBootLoader
extends BootLoader {
    @Override
    public String getName() {
        return "aquamarin";
    }

    @Override
    public String getDescription() {
        return "fish & chips";
    }

    @Override
    public Promise<Void, Exception, Void> boot(MeinAuthService meinAuthService, List<Service> services) throws SqlQueriesException, SQLException, IOException, ClassNotFoundException, JsonDeserializationException, JsonSerializationException, IllegalAccessException {
        services.forEach(service -> N.r(() -> {}));
        DeferredObject<Void, Exception, Void> done = new DeferredObject<Void, Exception, Void>();
        done.resolve(null);
        return done;
    }

    private AquaService newInstance(String name, boolean isServer) throws SqlQueriesException {
        Service service = this.createService(name);
        File workingDirectory = new File(String.valueOf(this.bootLoaderDir.getAbsolutePath()) + File.separator + service.getUuid().v());
        AquaService aquaService = isServer ? new AquaServerService(this.meinAuthService, workingDirectory) : new AquaClientService(this.meinAuthService, workingDirectory);
        aquaService.setUuid(service.getUuid().v());
        this.meinAuthService.registerMeinService(aquaService);
        this.meinAuthService.execute(aquaService);
        return aquaService;
    }

    public AquaClientService newClientService(String name) throws SqlQueriesException {
        return (AquaClientService)this.newInstance(name, false);
    }

    public AquaServerService newServerService(String name) throws SqlQueriesException {
        return (AquaServerService)this.newInstance(name, true);
    }

    private Service createService(String name) throws SqlQueriesException {
        ServiceType type = this.meinAuthService.getDatabaseManager().getServiceTypeByName(this.getName());
        Service service = this.meinAuthService.getDatabaseManager().createService(type.getId().v(), name);
        return service;
    }
}

