/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.networking.service;

import com.sun.istack.internal.NotNull;
import de.mein.auth.data.IPayload;
import de.mein.auth.data.db.Certificate;
import de.mein.auth.jobs.Job;
import de.mein.auth.service.MeinAuthService;
import de.mein.auth.socket.process.val.MeinServicesPayload;
import de.mein.auth.socket.process.val.MeinValidationProcess;
import de.mein.auth.socket.process.val.Request;
import de.mein.auth.tools.N;
import java.io.File;
import org.jdeferred.Deferred;
import org.jdeferred.Promise;
import org.jdeferred.impl.DeferredObject;
import uni.hro.client.ClientGui;
import uni.hro.model.Bucket;
import uni.hro.networking.job.SendBucketJob;
import uni.hro.networking.job.StartSimulationJob;
import uni.hro.networking.service.AquaService;

public class AquaClientService
extends AquaService {
    private final ClientGui gui = new ClientGui(this);
    private Long serverId;
    private String serverServiceUuid;

    public AquaClientService(MeinAuthService meinAuthService, File serviceInstanceWorkingDirectory) {
        super(meinAuthService, serviceInstanceWorkingDirectory);
    }

    public Promise<Void, Void, Void> regAsClient(@NotNull String address, @NotNull int port, @NotNull int portCert) throws InterruptedException {
        DeferredObject<Void, Void, Void> deferred = new DeferredObject<Void, Void, Void>();
        Promise<MeinValidationProcess, Exception, Void> connected = this.meinAuthService.connect(null, address, port, portCert, true);
        connected.done(val -> N.r(() -> {
            this.serverId = val.getPartnerCertificate().getId().v();
            Request<MeinServicesPayload> allowedRemoteServices = this.meinAuthService.getAllowedServices(this.serverId);
            allowedRemoteServices.done(remoteServicesPayload -> N.r(() -> {
                this.serverServiceUuid = remoteServicesPayload.getServices().get(0).getUuid().v();
                MeinServicesPayload allowedServices = this.meinAuthService.getAllowedServicesFor(val.getPartnerCertificate().getId().v());
                Request regRequest = val.request(this.serverServiceUuid, "will client sein", allowedServices);
                regRequest.done(whatEver -> {
                    Deferred deferred = deferred.resolve(null);
                }).fail(whatEver -> {
                    Deferred deferred = deferred.reject(null);
                });
            }));
        })).fail(nil -> System.err.println("AquaClientService.regAsClient"));
        return deferred;
    }

    @Override
    public void handleMessage(IPayload payload, Certificate partnerCertificate, String intent) {
        if (intent != null && intent.equals("start simulation")) {
            this.addJob((StartSimulationJob)payload);
        }
    }

    @Override
    public void connectionAuthenticated(Certificate partnerCertificate) {
    }

    @Override
    public void onMeinAuthIsUp() {
    }

    @Override
    protected void workWorkWork(Job job) {
        if (job instanceof SendBucketJob) {
            SendBucketJob bucketJob = (SendBucketJob)job;
            this.sendBucket(((SendBucketJob)job).getBucket());
        }
    }

    private void sendBucket(Bucket bucket) {
        N.r(() -> {
            Promise<MeinValidationProcess, Exception, Void> promise = this.meinAuthService.connect(this.serverId).done(validationProcess -> N.r(() -> validationProcess.message(this.serverServiceUuid, "will den nicht mehr", bucket))).fail(nil -> System.err.println("Eimer sagt :("));
        });
    }

    public Long getServerId() {
        return this.serverId;
    }

    public void setServerId(Long serverId) {
        this.serverId = serverId;
    }

    public void setServerServiceUuid(String serverServiceUuid) {
        this.serverServiceUuid = serverServiceUuid;
    }
}

