/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.networking.service;

import de.mein.auth.data.IPayload;
import de.mein.auth.data.db.Certificate;
import de.mein.auth.jobs.Job;
import de.mein.auth.jobs.ServiceMessageHandlerJob;
import de.mein.auth.service.MeinAuthService;
import de.mein.auth.socket.process.val.MeinServicesPayload;
import de.mein.auth.socket.process.val.Request;
import de.mein.auth.tools.N;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import uni.hro.model.Bucket;
import uni.hro.model.Fish;
import uni.hro.networking.job.StartSimulationJob;
import uni.hro.networking.service.AquaService;
import uni.hro.server.ServerGui;
import uni.hro.simulation.Simulation;

public class AquaServerService
extends AquaService {
    private Map<Long, MeinServicesPayload> clientDetailsMap = new HashMap<Long, MeinServicesPayload>();
    private Set<Fish> availableFishes = new HashSet<Fish>();
    private ServerGui gui = new ServerGui();

    public AquaServerService(MeinAuthService meinAuthService, File serviceInstanceWorkingDirectory) {
        super(meinAuthService, serviceInstanceWorkingDirectory);
        this.gui.setStartListener(new StartListener());
    }

    public void startSimulation(int numberOfFishes, int numberOfKraken, int numberOfPlants, int numberOfStones, int width, int height) {
        StartSimulationJob startSimulationJob = new StartSimulationJob(numberOfFishes, numberOfKraken, numberOfPlants, numberOfStones, width, height);
        this.clientDetailsMap.forEach((certId, meinServicesPayload) -> N.r(() -> this.meinAuthService.connect((Long)certId).done(validationProcess -> N.r(() -> validationProcess.message(meinServicesPayload.getServices().get(0).getUuid().v(), "start simulation", startSimulationJob)))));
        this.addJob(new StartSimulationJob(numberOfFishes, numberOfKraken, numberOfPlants, numberOfStones, width, height));
    }

    @Override
    public void handleMessage(IPayload payload, Certificate partnerCertificate, String intent) {
        this.addJob(new ServiceMessageHandlerJob().setMessage(payload).setIntent(intent).setPartnerCertificate(partnerCertificate));
    }

    @Override
    public void connectionAuthenticated(Certificate partnerCertificate) {
        System.out.println("AquaServerService.connectionAuthenticated");
    }

    @Override
    public void onMeinAuthIsUp() {
    }

    @Override
    protected void workWorkWork(Job job) {
        if (job instanceof ServiceMessageHandlerJob) {
            ServiceMessageHandlerJob messageHandlerJob = (ServiceMessageHandlerJob)job;
            if (messageHandlerJob.isRequest()) {
                Request request = messageHandlerJob.getRequest();
                if (request.getIntent().equals("will client sein")) {
                    MeinServicesPayload payload = (MeinServicesPayload)request.getPayload();
                    this.clientDetailsMap.put(((ServiceMessageHandlerJob)job).getPartnerCertificate().getId().v(), payload);
                    request.resolve(null);
                }
            } else if (messageHandlerJob.getIntent() != null && messageHandlerJob.getIntent().equals("will den nicht mehr")) {
                Bucket bucket = (Bucket)messageHandlerJob.getPayLoad();
                this.availableFishes.addAll(bucket.getFishes());
            }
        }
    }

    class StartListener
    implements ActionListener {
        StartListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AquaServerService.this.gui.storeCurrentSettings();
            if (AquaServerService.this.gui.getReset()) {
                Simulation resetSimulation = new Simulation(0, 0, 0, 0, 0, 0);
                resetSimulation.reset();
            }
            AquaServerService.this.gui.connectClient("localhost");
            AquaServerService.this.startSimulation(AquaServerService.this.gui.getNumberOfFishes(), AquaServerService.this.gui.getNumberOfKraken(), AquaServerService.this.gui.getNumberOfPlants(), AquaServerService.this.gui.getNumberOfStones(), AquaServerService.this.gui.getXForSimulation(), AquaServerService.this.gui.getYForSimulation());
            AquaServerService.this.gui.setVisible(false);
        }
    }
}

