/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.networking.service;

import de.mein.auth.data.db.Certificate;
import de.mein.auth.jobs.Job;
import de.mein.auth.jobs.ServiceMessageHandlerJob;
import de.mein.auth.service.MeinAuthService;
import de.mein.auth.service.MeinService;
import de.mein.auth.socket.process.transfer.MeinIsolatedProcess;
import de.mein.auth.socket.process.val.Request;
import de.mein.auth.tools.WaitLock;
import de.mein.core.serialize.serialize.tools.OTimer;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import uni.hro.client.Aquarium;
import uni.hro.model.World;
import uni.hro.networking.job.SimulateJob;
import uni.hro.networking.job.StartSimulationJob;
import uni.hro.networking.job.StopSimulatingJob;
import uni.hro.simulation.Simulation;

public abstract class AquaService
extends MeinService {
    private static int framteTime = 0;
    public int generationNumber = 1;
    public int generationBeforeJump = 1;
    public int jumpToGeneration = 1;
    protected Simulation simulation;
    protected Aquarium aquarium;
    protected World world;
    private boolean simulating = false;
    private OTimer oTimer = new OTimer("Simulation duration");
    private OTimer fps = new OTimer("fsp").start();
    private Timer timer = new Timer("el simulatore");

    public AquaService(MeinAuthService meinAuthService, File serviceInstanceWorkingDirectory) {
        super(meinAuthService, serviceInstanceWorkingDirectory);
    }

    @Override
    public void handleRequest(Request request) throws Exception {
        this.addJob(new ServiceMessageHandlerJob().setRequest(request));
    }

    @Override
    public void handleCertificateSpotted(Certificate partnerCertificate) {
    }

    @Override
    public void onIsolatedConnectionEstablished(MeinIsolatedProcess isolatedProcess) {
    }

    @Override
    protected final void workWork(Job job) throws Exception {
        if (job instanceof SimulateJob) {
            this.simulate();
            if (this.simulating) {
                this.aquarium.getaquariumJPanel().prepareDrawing();
            }
            this.addJob(new SimulateJob());
        } else if (job instanceof StopSimulatingJob) {
            this.simulating = false;
        } else if (job instanceof StartSimulationJob) {
            StartSimulationJob simJob = (StartSimulationJob)job;
            this.simulating = true;
            this.simulation = new Simulation(simJob.getFishes(), simJob.getKraken(), simJob.getPlants(), simJob.getStones(), simJob.getWidth(), simJob.getHeight());
            this.world = this.simulation.getWorld();
            this.aquarium = new Aquarium(this.world);
            this.simulation.prepare(false);
            this.addJob(new SimulateJob());
        } else {
            this.workWorkWork(job);
        }
    }

    protected abstract void workWorkWork(Job var1);

    protected void simulate() {
        OTimer performanceTimer = new OTimer("simulating.only");
        performanceTimer.start();
        boolean hasFinished = false;
        while (!hasFinished) {
            this.oTimer.start();
            performanceTimer.start();
            hasFinished = this.simulation.simulate();
            performanceTimer.stop();
            this.generationNumber = this.aquarium.getGeneration();
            this.aquarium.getaquariumJPanel().setCurrentGeneration(this.generationNumber);
            this.jumpToGeneration = this.aquarium.getaquariumJPanel().getJumpNumberOfGenerations();
            if (this.generationNumber > this.jumpToGeneration) {
                framteTime = 10;
                this.aquarium.repaint();
                this.aquarium.getaquariumJPanel().getJumpNumberOfGenerations();
            } else {
                framteTime = 0;
            }
            this.oTimer.stop();
            if (this.oTimer.getDurationInMS() < (long)framteTime) {
                final WaitLock waitLock = new WaitLock().lock();
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        waitLock.unlock();
                    }
                }, (long)framteTime - this.oTimer.getDurationInMS());
                waitLock.lock();
                waitLock.unlock();
            }
            this.oTimer.reset();
        }
        performanceTimer.print();
        ++this.generationNumber;
        this.simulation.evolve();
        this.simulation.prepare(true);
        this.fastforward();
    }

    private void fastforward() {
        this.aquarium.getaquariumJPanel().setFastforward(true);
        this.aquarium.setGeneration(this.generationNumber);
        this.aquarium.refreshLabel();
        this.aquarium.repaint();
    }

    @Override
    protected ExecutorService createExecutorService(ThreadFactory threadFactory) {
        return Executors.newCachedThreadPool(threadFactory);
    }
}

