/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.server;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import uni.hro.server.Settings;

public class ServerGui
extends JFrame {
    private static GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    private JPanel contentPane;
    private JTextField ClientField;
    private JButton startButton;
    private JButton exitButton;
    private JScrollPane scrollPane;
    private JPanel panel;
    private JPanel numberPanel;
    private JLabel lblNumberOfClients;
    private JLabel numLabel;
    private int noC = 0;
    private Integer[] numbers = new Integer[24];
    private Integer[] numbers2 = new Integer[13];
    private JLabel lblFische;
    private JComboBox fischBox;
    private JLabel lblKraken;
    private JComboBox krakenBox;
    private JLabel lblSteine;
    private JComboBox steinBox;
    private JLabel lblPflanzen;
    private JComboBox pflanzenBox;
    private JRadioButton rdbtnVollbild;
    private JRadioButton rdbtnFenster;
    private JLabel lblX;
    private JTextField textField_X;
    private JLabel lblY;
    private JTextField textField_Y;
    private JCheckBox resetBox;
    private Settings lastRunSettings = Settings.exists() ? Settings.load() : new Settings(0, 15, 2, 1, 1, 480, 360);

    public ServerGui() {
        this.setMinimumSize(new Dimension(479, 319));
        this.setTitle("Aquarium Server");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 500, 340);
        this.numbers = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 50, 100, 200};
        this.numbers2 = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 20};
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new MigLayout("", "[150px:n:150px][150px:n:150px,grow][150px:n:150px,grow]", "[30px:n:30px][30px:n:30px,grow][50px:n:50px,grow][][][][][]"));
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.contentPane.add((Component)this.scrollPane, "cell 0 0 3 2,grow");
        this.panel = new JPanel();
        this.scrollPane.setViewportView(this.panel);
        this.ClientField = this.addClient();
        this.numberPanel = new JPanel();
        this.contentPane.add((Component)this.numberPanel, "cell 0 2 3 1,alignx center,aligny center");
        this.lblNumberOfClients = new JLabel("Number of Clients:");
        this.lblNumberOfClients.setFont(new Font("Tahoma", 1, 16));
        this.numberPanel.add(this.lblNumberOfClients);
        this.numLabel = new JLabel("0");
        this.numLabel.setFont(new Font("Tahoma", 0, 16));
        this.numberPanel.add(this.numLabel);
        this.exitButton = new JButton("Exit");
        this.exitButton.setPreferredSize(new Dimension(144, 23));
        this.exitButton.setMinimumSize(new Dimension(144, 23));
        this.exitButton.setMaximumSize(new Dimension(144, 23));
        this.contentPane.add((Component)this.exitButton, "cell 0 3,alignx center,aligny center");
        this.startButton = new JButton("Start");
        this.startButton.setMaximumSize(new Dimension(144, 23));
        this.startButton.setMinimumSize(new Dimension(144, 23));
        this.startButton.setPreferredSize(new Dimension(144, 23));
        this.contentPane.add((Component)this.startButton, "cell 2 3,alignx center,aligny center");
        this.fischBox = new JComboBox<Integer>(this.numbers);
        this.contentPane.add((Component)this.fischBox, "flowx,cell 0 4");
        this.fischBox.setSelectedIndex(this.lastRunSettings.getNumFish());
        this.lblFische = new JLabel("Fische");
        this.contentPane.add((Component)this.lblFische, "cell 0 4");
        this.rdbtnVollbild = new JRadioButton("Vollbild");
        this.rdbtnVollbild.setSelected(true);
        this.contentPane.add((Component)this.rdbtnVollbild, "cell 1 4,alignx right");
        this.rdbtnFenster = new JRadioButton("Fenster");
        this.contentPane.add((Component)this.rdbtnFenster, "flowx,cell 2 4");
        ButtonGroup group = new ButtonGroup();
        group.add(this.rdbtnVollbild);
        group.add(this.rdbtnFenster);
        this.rdbtnVollbild.addActionListener(new fullscreenListener());
        this.rdbtnFenster.addActionListener(new windowListener());
        this.krakenBox = new JComboBox<Integer>(this.numbers);
        this.contentPane.add((Component)this.krakenBox, "flowx,cell 0 5");
        this.krakenBox.setSelectedIndex(this.lastRunSettings.getNumKraken());
        this.lblKraken = new JLabel("Kraken");
        this.contentPane.add((Component)this.lblKraken, "cell 0 5");
        this.lblX = new JLabel("x:");
        this.contentPane.add((Component)this.lblX, "flowx,cell 2 5");
        this.steinBox = new JComboBox<Integer>(this.numbers2);
        this.contentPane.add((Component)this.steinBox, "flowx,cell 0 6");
        this.steinBox.setSelectedIndex(this.lastRunSettings.getNumStone());
        this.lblSteine = new JLabel("Steine");
        this.contentPane.add((Component)this.lblSteine, "cell 0 6");
        this.pflanzenBox = new JComboBox<Integer>(this.numbers2);
        this.contentPane.add((Component)this.pflanzenBox, "flowx,cell 0 7");
        this.pflanzenBox.setSelectedIndex(this.lastRunSettings.getNumPlant());
        this.lblPflanzen = new JLabel("Pflanzen");
        this.contentPane.add((Component)this.lblPflanzen, "cell 0 7");
        this.textField_X = new JTextField();
        this.textField_X.setText("" + this.lastRunSettings.getX());
        this.contentPane.add((Component)this.textField_X, "cell 2 5");
        this.textField_X.setColumns(6);
        this.textField_X.setEnabled(false);
        this.lblY = new JLabel(" y:");
        this.contentPane.add((Component)this.lblY, "cell 2 5");
        this.textField_Y = new JTextField();
        this.textField_Y.setText("" + this.lastRunSettings.getY());
        this.contentPane.add((Component)this.textField_Y, "cell 2 5");
        this.textField_Y.setColumns(6);
        this.textField_Y.setEnabled(false);
        this.resetBox = new JCheckBox("Reset");
        this.contentPane.add((Component)this.resetBox, "cell 2 7");
        this.resetBox.setSelected(true);
        this.resetBox.addActionListener(new resetListener());
        String os = "os.name";
        Properties prop = System.getProperties();
        System.out.println(prop.getProperty(os));
        if ("4.4.50-v7+".equals(System.getProperty("os.version"))) {
            this.setResizable(false);
            this.setUndecorated(true);
            gd.setFullScreenWindow(this);
            this.rdbtnVollbild.setEnabled(false);
            this.rdbtnVollbild.setSelected(true);
            this.rdbtnFenster.setVisible(false);
            this.lblX.setVisible(false);
            this.lblY.setVisible(false);
            this.textField_X.setVisible(false);
            this.textField_Y.setVisible(false);
        } else {
            this.setResizable(true);
            this.setUndecorated(false);
            this.setMinimumSize(new Dimension(515, 375));
        }
        this.setVisible(true);
        this.exitButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                System.exit(0);
            }
        });
        this.connectClient("localhost");
    }

    public int getXForSimulation() {
        if (this.rdbtnVollbild.isSelected()) {
            return gd.getDisplayMode().getWidth();
        }
        return Integer.parseInt(this.textField_X.getText());
    }

    public int getYForSimulation() {
        if (this.rdbtnVollbild.isSelected()) {
            return gd.getDisplayMode().getHeight();
        }
        return Integer.parseInt(this.textField_Y.getText());
    }

    public int getNumberOfFishes() {
        return this.numbers[this.fischBox.getSelectedIndex()];
    }

    public int getNumberOfKraken() {
        return this.numbers[this.krakenBox.getSelectedIndex()];
    }

    public int getNumberOfPlants() {
        return this.numbers[this.pflanzenBox.getSelectedIndex()];
    }

    public int getNumberOfStones() {
        return this.numbers[this.steinBox.getSelectedIndex()];
    }

    public boolean getReset() {
        return this.resetBox.isSelected();
    }

    public void connectClient(String ipAddress) {
        ++this.noC;
        this.ClientField.setText(String.valueOf(this.noC) + ": " + ipAddress);
        this.ClientField.setBackground(new Color(0, 255, 0));
        this.ClientField.setToolTipText(ipAddress);
        this.ClientField = this.addClient();
        this.numLabel.setText("" + this.noC);
    }

    private JTextField addClient() {
        this.panel.setLayout(new FlowLayout(0, 10, 10));
        JTextField textField = new JTextField();
        textField.setFont(new Font("Tahoma", 0, 20));
        textField.setAlignmentY(1.0f);
        textField.setAlignmentX(1.0f);
        textField.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        textField.setColumns(11);
        this.panel.add(textField);
        textField.setHorizontalAlignment(0);
        textField.setText("Waiting for Clients...");
        textField.setEnabled(false);
        textField.setEditable(false);
        this.panel.revalidate();
        this.panel.repaint();
        return textField;
    }

    public void storeCurrentSettings() {
        this.lastRunSettings.setNumFish(this.fischBox.getSelectedIndex());
        this.lastRunSettings.setNumKraken(this.krakenBox.getSelectedIndex());
        this.lastRunSettings.setNumPlant(this.pflanzenBox.getSelectedIndex());
        this.lastRunSettings.setNumStone(this.steinBox.getSelectedIndex());
        this.lastRunSettings.setX(Integer.parseInt(this.textField_X.getText()));
        this.lastRunSettings.setY(Integer.parseInt(this.textField_Y.getText()));
        this.lastRunSettings.store();
    }

    public void setStartListener(ActionListener l) {
        this.startButton.addActionListener(l);
    }

    class fullscreenListener
    implements ActionListener {
        fullscreenListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ServerGui.this.textField_X.setEnabled(false);
            ServerGui.this.textField_Y.setEnabled(false);
        }
    }

    class resetListener
    implements ActionListener {
        resetListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ServerGui.this.resetBox.isSelected()) {
                ServerGui.this.fischBox.setSelectedIndex(ServerGui.this.lastRunSettings.getNumFish());
                ServerGui.this.fischBox.setEnabled(false);
                ServerGui.this.krakenBox.setSelectedIndex(ServerGui.this.lastRunSettings.getNumKraken());
                ServerGui.this.krakenBox.setEnabled(false);
                ServerGui.this.steinBox.setSelectedIndex(ServerGui.this.lastRunSettings.getNumStone());
                ServerGui.this.steinBox.setEnabled(false);
                ServerGui.this.pflanzenBox.setSelectedIndex(ServerGui.this.lastRunSettings.getNumPlant());
                ServerGui.this.pflanzenBox.setEnabled(false);
                ServerGui.this.textField_X.setText("" + ServerGui.this.lastRunSettings.getX());
                ServerGui.this.textField_X.setEnabled(false);
                ServerGui.this.textField_Y.setText("" + ServerGui.this.lastRunSettings.getY());
                ServerGui.this.textField_Y.setEnabled(false);
            } else {
                ServerGui.this.fischBox.setEnabled(true);
                ServerGui.this.krakenBox.setEnabled(true);
                ServerGui.this.steinBox.setEnabled(true);
                ServerGui.this.pflanzenBox.setEnabled(true);
                if (ServerGui.this.rdbtnVollbild.isSelected()) {
                    ServerGui.this.textField_X.setEnabled(false);
                    ServerGui.this.textField_Y.setEnabled(false);
                } else {
                    ServerGui.this.textField_X.setEnabled(true);
                    ServerGui.this.textField_Y.setEnabled(true);
                }
            }
        }
    }

    class windowListener
    implements ActionListener {
        windowListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ServerGui.this.resetBox.isSelected()) {
                ServerGui.this.textField_X.setEnabled(false);
                ServerGui.this.textField_Y.setEnabled(false);
            } else {
                ServerGui.this.textField_X.setEnabled(true);
                ServerGui.this.textField_Y.setEnabled(true);
            }
        }
    }
}

