/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Settings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String path = "\\db\\settings.ser";
    private int num_gen;
    private int num_fish;
    private int num_kraken;
    private int num_plant;
    private int num_stone;
    private int view_x;
    private int view_y;

    public Settings(int gen, int fish, int kraken, int plant, int stone, int x, int y) {
        this.num_gen = gen;
        this.num_fish = fish;
        this.num_kraken = kraken;
        this.num_plant = plant;
        this.num_stone = stone;
        this.view_x = x;
        this.view_y = y;
    }

    public Settings() {
        this.num_gen = 0;
        this.num_fish = 15;
        this.num_kraken = 2;
        this.num_plant = 1;
        this.num_stone = 1;
        this.view_x = 480;
        this.view_y = 360;
    }

    public Settings(Settings set) {
        this.num_gen = set.getNumGen();
        this.num_fish = set.getNumFish();
        this.num_kraken = set.getNumKraken();
        this.num_plant = set.getNumPlant();
        this.num_stone = set.getNumStone();
        this.view_x = set.getX();
        this.view_y = set.getY();
    }

    public static Settings load() {
        Settings settings;
        try {
            File dest = new File(String.valueOf(System.getProperty("user.dir")) + path);
            FileInputStream fos = new FileInputStream(dest);
            ObjectInputStream oos = new ObjectInputStream(fos);
            settings = (Settings)oos.readObject();
            oos.close();
            fos.close();
        }
        catch (IOException e) {
            return new Settings();
        }
        catch (ClassNotFoundException e) {
            return new Settings();
        }
        return settings;
    }

    public void store() {
        try {
            File dest = new File(String.valueOf(System.getProperty("user.dir")) + path);
            FileOutputStream fos = new FileOutputStream(dest);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this);
            oos.close();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean exists() {
        File f = new File(String.valueOf(System.getProperty("user.dir")) + path);
        return f.exists();
    }

    public static boolean delete() {
        File f = new File(String.valueOf(System.getProperty("user.dir")) + path);
        return f.delete();
    }

    public boolean match(Settings settings) {
        return this.softMatch(settings);
    }

    public static boolean match(Settings s1, Settings s2) {
        return s1.match(s2);
    }

    public boolean match(Settings settings, String mode) {
        switch (mode) {
            case "soft": {
                return this.softMatch(settings);
            }
            case "hard": {
                return this.hardMatch(settings);
            }
        }
        return false;
    }

    public static boolean match(Settings s1, Settings s2, String mode) {
        return s1.match(s2, mode);
    }

    private boolean softMatch(Settings settings) {
        return this.num_fish == settings.getNumFish() && this.num_kraken == settings.getNumKraken();
    }

    private boolean hardMatch(Settings settings) {
        if (this.num_plant == settings.getNumPlant() && this.num_stone == settings.getNumStone() && this.view_x == settings.getX() && this.view_y == settings.getY()) {
            return this.softMatch(settings);
        }
        return false;
    }

    public int getNumGen() {
        return this.num_gen;
    }

    public void setNumGen(int gen) {
        this.num_gen = gen;
    }

    public int getNumFish() {
        return this.num_fish;
    }

    public void setNumFish(int fish) {
        this.num_fish = fish;
    }

    public int getNumKraken() {
        return this.num_kraken;
    }

    public void setNumKraken(int kraken) {
        this.num_kraken = kraken;
    }

    public int getNumPlant() {
        return this.num_plant;
    }

    public void setNumPlant(int plant) {
        this.num_plant = plant;
    }

    public int getNumStone() {
        return this.num_stone;
    }

    public void setNumStone(int stone) {
        this.num_stone = stone;
    }

    public int getX() {
        return this.view_x;
    }

    public void setX(int x) {
        this.view_x = x;
    }

    public int getY() {
        return this.view_y;
    }

    public void setY(int y) {
        this.view_y = y;
    }
}

