/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.simulation;

import com.anji.integration.ActivatorTranscriber;
import com.anji.neat.DummyEvolver;
import com.anji.neat.Evolver;
import com.anji.util.Properties;
import com.anji.util.Reset;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jgap.Chromosome;
import uni.hro.model.Consumable;
import uni.hro.model.Creature;
import uni.hro.model.Fish;
import uni.hro.model.Food;
import uni.hro.model.Kraken;
import uni.hro.model.World;
import uni.hro.model.WorldEntity;
import uni.hro.server.Settings;
import uni.hro.simulation.SimulationCallable;

public class Simulation {
    private final int noOfKraken;
    private final int noOfFishes;
    private final int aquariumWidth;
    private final int aquariumHeight;
    private final int noOfCores;
    private ActivatorTranscriber factory;
    private World world;
    private Evolver fishEvolver;
    private Evolver krakenEvolver;
    private ExecutorService executor;
    private int stepNumber;
    private Set<WorldEntity> allCreatures;
    private String fishProps = "/uni/hro/nn/fish.properties";
    private String krakenProps = "/uni/hro/nn/kraken.properties";
    private Hashtable<Creature, Void> deadStuff = new Hashtable();
    private Random random = new Random();

    public Simulation(Integer numberOfFishes, Integer numberOfKraken, int numberOfPlants, int numberOfStones, int aquariumWidth, int aquariumHeight) {
        this.world = World.createRandomWorld1(numberOfFishes, numberOfKraken, numberOfPlants, numberOfStones, aquariumWidth, aquariumHeight);
        this.noOfFishes = numberOfFishes;
        this.noOfKraken = numberOfKraken;
        this.aquariumWidth = aquariumWidth;
        this.aquariumHeight = aquariumHeight;
        this.noOfCores = Runtime.getRuntime().availableProcessors();
        try {
            this.executor = Executors.newFixedThreadPool(this.noOfCores);
            Properties props = new Properties();
            InputStream in = this.getClass().getResourceAsStream(this.fishProps);
            props.load(in);
            in.close();
            props.setProperty("stimulus.size", Fish.calcInputSize().toString());
            props.setProperty("popul.size", numberOfFishes.toString());
            this.fishEvolver = numberOfFishes > 0 ? Evolver.instance(props) : new DummyEvolver();
            this.fishEvolver.setName("fishes");
            in = this.getClass().getResourceAsStream(this.krakenProps);
            props = new Properties();
            props.load(in);
            in.close();
            props.setProperty("stimulus.size", Kraken.calcInputSize().toString());
            props.setProperty("popul.size", numberOfKraken.toString());
            this.krakenEvolver = numberOfKraken > 0 ? Evolver.instance(props) : new DummyEvolver();
            this.krakenEvolver.setName("krakense");
            this.factory = (ActivatorTranscriber)props.singletonObjectProperty(ActivatorTranscriber.class);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void evolve() {
        this.fishEvolver.evolveGeneration();
        this.krakenEvolver.evolveGeneration();
    }

    public boolean simulate() {
        int minScreenWidth = 20;
        int maxScreenWidth = this.world.getWidth() - 20;
        int minScreenHeight = 20;
        int maxScreenHeight = this.world.getHeight() - 20;
        double inverseProb = 0.99;
        int i = 0;
        while (i < 1) {
            Random random = new Random();
            if ((double)random.nextFloat() > inverseProb) {
                float xcoordinate = World.generateRandom(minScreenWidth, maxScreenWidth);
                float ycoordinate = World.generateRandom(minScreenHeight, maxScreenHeight);
                this.world.getEntities().add(new Food(this.world, xcoordinate, ycoordinate));
            }
            ++i;
        }
        WorldEntity[] entities = this.world.getEntities().toArray(new WorldEntity[0]);
        return this.process(entities);
    }

    private boolean process(WorldEntity[] entities) {
        int size;
        int noOfThreads;
        ArrayList probablyExistingStuff;
        boolean everythingIsDead;
        block10: {
            ++this.stepNumber;
            everythingIsDead = true;
            probablyExistingStuff = new ArrayList(entities.length);
            noOfThreads = this.noOfCores;
            size = entities.length;
            if (size < noOfThreads) {
                noOfThreads = size;
            }
            if (size >= 1) break block10;
            return true;
        }
        try {
            int width = size / noOfThreads;
            int rest = size - noOfThreads * width;
            int startIndex = 0;
            int endIndex = width;
            ArrayList<SimulationCallable> callables = new ArrayList<SimulationCallable>();
            int i = 0;
            while (i < noOfThreads) {
                if (rest > 0) {
                    ++endIndex;
                    --rest;
                }
                SimulationCallable callable = new SimulationCallable(entities, startIndex, endIndex, this.factory);
                callables.add(callable);
                startIndex = endIndex;
                endIndex += width;
                ++i;
            }
            List futures = this.executor.invokeAll(callables);
            for (Future future : futures) {
                List futureResult = (List)future.get();
                if (futureResult == null) continue;
                probablyExistingStuff.addAll(futureResult);
            }
            this.world.getEntities().clear();
            Set<WorldEntity> existingStuff = this.world.getEntities();
            for (WorldEntity worldEntity : probablyExistingStuff) {
                Creature creature;
                if (worldEntity instanceof Creature && (creature = (Creature)worldEntity).isAlive()) {
                    everythingIsDead = false;
                }
                if (worldEntity instanceof Consumable) {
                    Consumable consumable = (Consumable)worldEntity;
                    if (consumable.isConsumed()) continue;
                    existingStuff.add(consumable);
                    continue;
                }
                existingStuff.add(worldEntity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return everythingIsDead;
    }

    public World getWorld() {
        return this.world;
    }

    public void prepare(boolean removeFood) {
        this.stepNumber = 0;
        List<Chromosome> fishChroms = this.fishEvolver.nextGeneration();
        List<Chromosome> krakenChroms = this.krakenEvolver.nextGeneration();
        int fishCount = 0;
        int krakenCount = 0;
        HashSet<WorldEntity> entities = new HashSet<WorldEntity>(this.world.getEntities());
        this.world.getEntities().clear();
        for (WorldEntity worldEntity : entities) {
            if (worldEntity instanceof Food) {
                if (removeFood) continue;
                this.world.getEntities().add(worldEntity);
                continue;
            }
            if (worldEntity instanceof Creature) continue;
            this.world.getEntities().add(worldEntity);
        }
        int i = 0;
        while (i < this.noOfFishes) {
            Fish fish = new Fish(this.world, this.random(this.aquariumWidth), this.random(this.aquariumHeight));
            fish.setChromosome(fishChroms.get(fishCount++));
            this.world.getEntities().add(fish);
            ++i;
        }
        i = 0;
        while (i < this.noOfKraken) {
            Kraken kraken = new Kraken(this.world, this.random(this.aquariumWidth), this.random(this.aquariumHeight));
            kraken.setChromosome(krakenChroms.get(krakenCount++));
            this.world.getEntities().add(kraken);
            ++i;
        }
        i = 0;
        while (i < 50) {
            Food food = new Food(this.world, this.random(this.aquariumWidth), this.random(this.aquariumHeight));
            this.world.getEntities().add(food);
            ++i;
        }
    }

    private float random(float range) {
        return this.random.nextFloat() * range;
    }

    public void reset() {
        try {
            System.out.print("Deleting previous creatures!");
            Properties props = new Properties();
            InputStream in = this.getClass().getResourceAsStream(this.fishProps);
            props.load(in);
            in.close();
            Reset resetter = new Reset(props);
            resetter.setUserInteraction(false);
            resetter.reset();
            props = new Properties();
            in = this.getClass().getResourceAsStream(this.krakenProps);
            props.load(in);
            in.close();
            resetter = new Reset(props);
            resetter.setUserInteraction(false);
            resetter.reset();
            Settings lastRunSettings = Settings.exists() ? Settings.load() : new Settings(0, 15, 2, 1, 1, 480, 360);
            lastRunSettings.setNumGen(1);
            lastRunSettings.store();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

