/*
 * Decompiled with CFR 0.152.
 */
package uni.hro.simulation;

import com.anji.integration.Activator;
import com.anji.integration.ActivatorTranscriber;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import uni.hro.model.Consumable;
import uni.hro.model.Creature;
import uni.hro.model.Food;
import uni.hro.model.HitBoxInputValueGenerator;
import uni.hro.model.Plant;
import uni.hro.model.WorldEntity;

public class SimulationCallable
implements Callable<List<WorldEntity>> {
    private final WorldEntity[] worldEntities;
    private final int startPos;
    private final int endPos;
    private final ActivatorTranscriber factory;
    private List<WorldEntity> probablyExistingEntities;

    public SimulationCallable(WorldEntity[] worldEntities, int startPos, int endPos, ActivatorTranscriber factory) {
        this.worldEntities = worldEntities;
        this.startPos = startPos;
        this.endPos = endPos;
        this.factory = factory;
        this.probablyExistingEntities = new ArrayList<WorldEntity>(endPos);
    }

    @Override
    public List<WorldEntity> call() throws Exception {
        int i = this.startPos;
        while (i < this.endPos) {
            WorldEntity worldEntity = this.worldEntities[i];
            try {
                this.probablyExistingEntities.add(worldEntity);
                if (worldEntity instanceof Creature) {
                    Creature creature = (Creature)worldEntity;
                    if (creature.isAlive()) {
                        creature.perceive();
                        creature.handleCollisions();
                        creature.swim();
                        creature.age();
                        double[] inputs = creature.createInputArray();
                        int count = SimulationCallable.fillArray(inputs, 0, creature.getInputValueGenerators());
                        Activator activator = creature.getActivator(this.factory);
                        double[] actions = activator.next(inputs);
                        creature.moveN(actions[0]);
                        creature.accelerate(actions[1]);
                        creature.moveS(actions[2]);
                        creature.decelerate(actions[3]);
                    } else {
                        creature.sink();
                    }
                } else if (worldEntity instanceof Food && !((Food)worldEntity).sink()) {
                    ((Consumable)worldEntity).consume();
                }
                if (worldEntity instanceof Plant) {
                    ((Plant)worldEntity).plantsInTheCurrentMovement();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return this.probablyExistingEntities;
    }

    private static <T> int fillArray(double[] arr, int pos, List<HitBoxInputValueGenerator> neurons) {
        for (HitBoxInputValueGenerator neuron : neurons) {
            arr[pos++] = neuron.getValue();
        }
        return pos;
    }

    private static int[] getHighestTwoValues(double[] in) {
        int[] result2 = new int[2];
        int first = 0;
        int sec = 0;
        double v1 = 0.0;
        double v2 = 0.0;
        int i = 0;
        while (i < in.length) {
            double v = in[i];
            if (v > v1) {
                v1 = v;
                first = i;
            } else if (v > v2) {
                sec = i;
                v2 = v;
            }
            ++i;
        }
        result2[0] = first;
        result2[1] = sec;
        return result2;
    }
}

